/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.datagen;

import com.google.common.collect.ImmutableMap;
import com.nyfaria.numismaticoverhaul.init.BlockInit;
import com.nyfaria.numismaticoverhaul.init.EntityInit;
import com.nyfaria.numismaticoverhaul.init.ItemInit;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class ModLangProvider
extends LanguageProvider {
    protected static final Map<String, String> REPLACE_LIST = ImmutableMap.of((Object)"tnt", (Object)"TNT", (Object)"sus", (Object)"");

    public ModLangProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
    }

    protected void addTranslations() {
        ItemInit.ITEMS.getEntries().forEach(this::itemLang);
        EntityInit.ENTITIES.getEntries().forEach(this::entityLang);
        BlockInit.BLOCKS.getEntries().forEach(this::blockLang);
    }

    protected void itemLang(RegistryObject<Item> entry) {
        if (!(entry.get() instanceof BlockItem) || entry.get() instanceof ItemNameBlockItem) {
            this.addItem((Supplier)entry, this.checkReplace(entry));
        }
    }

    protected void blockLang(RegistryObject<Block> entry) {
        this.addBlock((Supplier)entry, this.checkReplace(entry));
    }

    protected void entityLang(RegistryObject<EntityType<?>> entry) {
        this.addEntityType((Supplier)entry, this.checkReplace(entry));
    }

    protected String checkReplace(RegistryObject<?> registryObject) {
        return Arrays.stream(registryObject.getId().m_135815_().split("_")).map(this::checkReplace).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }

    protected String checkReplace(String string) {
        return REPLACE_LIST.containsKey(string) ? REPLACE_LIST.get(string) : StringUtils.capitalize((String)string);
    }
}

